﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports Microsoft.VisualBasic.FileIO

Public Class TaskPanelBase

    Private parameterList As System.Collections.Generic.List(Of Control)
    Private panelInstance As TaskPanelBase

    ' 常量
    Private Shared START_PARAMETER_LOCATION As New System.Drawing.Point(105, 65)
    Private Const Y_OFFSET As Integer = 30
    Private Const X_OFFSET As Integer = 230

    ''' <summary>
    ''' 此方法为每个参数创建控件，并在窗体上对这些控件
    ''' 进行合理布局
    ''' </summary>
    ''' <param name="name"></param>
    ''' <param name="value"></param>
    ''' <remarks></remarks>
    Protected Sub AddParameter(ByVal name As String, ByVal value As Control)

        Me.SuspendLayout()

        If (parameterList Is Nothing) Then
            parameterList = New System.Collections.Generic.List(Of Control)
        End If

        '为参数名创建一个标签
        Dim newParameter As New Label()
        newParameter.AutoSize = True
        newParameter.Location = GetNextLocation()
        newParameter.Name = name
        newParameter.Text = name
        newParameter.Font = New System.Drawing.Font("Microsoft Sans Serif", 15.75!, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        parameterList.Add(newParameter)

        '现在创建 Value 控件
        value.Location = New Point(newParameter.Location.X + X_OFFSET, newParameter.Location.Y)

        '将参数及其 Value 控件添加到该面板中
        Me.GroupBox2.Controls.Add(newParameter)
        Me.GroupBox2.Controls.Add(value)

        Me.EndParenLabel.Location = New Point(Me.EndParenLabel.Location.X, GetNextLocation().Y)
        Me.ResumeLayout()
        Me.Update()

    End Sub

    ''' <summary>
    ''' 获取下一个控件位置
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function GetNextLocation() As Point
        '如果这是第一个参数，则从该默认位置开始
        If (parameterList.Count < 1) Then
            Return START_PARAMETER_LOCATION
        Else
            Return New Point(START_PARAMETER_LOCATION.X, START_PARAMETER_LOCATION.Y + (parameterList.Count * Y_OFFSET))
        End If
    End Function

    ''' <summary>
    ''' 这是一个实用工具函数，用于将 UICancelOption 字符串转换为其枚举值
    ''' </summary>
    ''' <param name="userControl"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Protected Function ParseUICancelOption(ByVal userControl As ComboBox) As UICancelOption
        Dim cancelOption As UICancelOption

        Select Case CType(userControl.SelectedItem, String)
            Case "Do Nothing"
                cancelOption = UICancelOption.DoNothing
            Case "Throw Exception"
                cancelOption = UICancelOption.ThrowException
        End Select
        Return cancelOption
    End Function

    ''' <summary>
    ''' 将编码的字符串说明转换为正确类型。
    ''' </summary>
    ''' <param name="encodingStr"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Protected Function ParseEncoding(ByVal encodingStr As String) As System.Text.Encoding
        Dim retEncoding As System.Text.Encoding = System.Text.Encoding.UTF8
        Select Case encodingStr
            Case "ASCII", "Unicode"
                retEncoding = System.Text.Encoding.GetEncoding(encodingStr)
            Case "BigEndianUnicode"
                retEncoding = System.Text.Encoding.BigEndianUnicode
            Case "UTF7"
                retEncoding = System.Text.Encoding.UTF7
            Case "UTF8"
                retEncoding = System.Text.Encoding.UTF8
            Case "UTF32"
                retEncoding = System.Text.Encoding.UTF32
        End Select
        Return retEncoding
    End Function

End Class
